<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InterviewTool extends Model
{
    protected $table = 'interview_tools';
    protected $primaryKey = 'Tool_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Question_set_id',
        'Tool_type',
        'Title',
        'Content_url',
        'Score',
        'Config',
    ];

    protected $casts = [
        'Tool_type' => 'string',
        'Score' => 'float',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'Config' => 'array', // Assuming Config is JSON and should be cast to an array
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function questionSet()
    {
        return $this->belongsTo(ExamQuestion::class, 'Question_set_id', 'Question_id');
    }
}
?>
